/*:-----------------------------------------------------------------------------------
 * NUUN_ItemBook.js
 * 
 * Copyright (C) 2021 NUUN
 * This software is released under the MIT License.
 * http://opensource.org/licenses/mit-license.php
 * -------------------------------------------------------------------------------------
 * 
 */ 
/*:
 * @target MZ
 * @plugindesc アイテム図鑑
 * @author NUUN
 * @version 1.5.1
 * @base NUUN_Base
 * @orderAfter NUUN_Base
 *            
 * @help  
 * アイテム図鑑を実装します。
 * このプラグインではアイテム、武器、防具の表示内容を自由に設定することが出来ます。
 * 
 * ページの各項目の設定
 * 各ページの項目は「アイテム項目設定」「武器項目設定」「防具項目設定」から設定します。
 * 各項目の設定は、項目リスト横の()の数値の項目で設定できます。
 * 
 * 【名称の設定】
 * アイテム名以外で任意の名称を設定できます。
 * 無記入の場合はデーターベース及びこのプラグイン内で設定した名称が表示されます。
 * 
 * 【システム項目文字色の設定】
 * 名称の文字色を指定します。
 * 
 * 【パラメータ評価式の設定】
 * 評価式を記入します。オリジナルパラメータでは必ず記入してください。
 * itemでアイテムデータを取得できます。
 * オリジナルパラメータ以外で無記入の場合は自動的に参照されます。
 * 参照パラメータ
 * item　アイテムデータ
 * 
 * 【記述欄設定】
 * 記述欄はプラグインパラメータ「記述欄タグ名」に任意の文字列を記入してください。一部文字列は使用できない場合もありますので注意してください。
 * desc1と記入した場合はアイテム、武器、防具のメモ欄にdesc1:ああああと記入したとき、記述欄タグ名にdesc1と記入した項目に「ああああ」と表示されます。
 * 
 * 【X表示位置】
 * 表示する列を指定します。
 * 
 * 【Y表示位置】
 * 表示する行を指定します。
 * 
 * 【X座標設定】
 * 表示位置からの相対座標シフト。
 * 
 * 【Y座標設定】
 * 表示位置からの相対座標シフト。
 * 
 * 【項目横幅設定】
 * 横幅を指定します。指定しない場合は自動調整されます。
 * 
 * 【項目表示モード】
 * 項目を複数列に跨いで表示します。
 * 
 * 【システム項目横幅】
 * システム文字の表示幅を指定します。
 * 
 * 【名称、アイテム名表示位置】
 * 名称、アイテム名の文字の位置を指定します。
 * 
 * 【単位】
 * 接尾につける単位を設定します。オリジナルパラメータ、成功率で設定できます。
 * 
 * 【コンテンツ背景表示】
 * 一部を除く黒い背景（デフォルトの場合）を表示、表表示かを設定します。
 * 能力値、所持数、最大所持数、価格、オリジナルパラメータ、使用可能時、消耗、速度補正率、得TP、武器タイプ、防具タイプ、装備タイプで設定可能です。
 * 
 * 【記述欄、個別指定画像タグ名】
 * 任意の文字列を記入してください。一部文字列は使用できない場合もありますのでその場合は''で囲むと表示される場合があります。
 * アイテム、武器、防具のメモ欄
 * <[tag]:[text]> 記述欄のテキスト
 * [tag]:記述欄タグ名 [text]:表示するテキスト。 改行すれば何行でも表示可能ですので、独自の項目を追加することも可能です。
 * <desc1:ああああ> desc1とタグ付けされた項目に「ああああ」が表示されます。
 * 文章を表示させる場合は<desc1:[text]>と記入してください。
 * 
 * 【共通画像】
 * アイテム、武器、防具すべてで表示される共通の画像を指定します。
 * 
 * 【画像の最大縦幅】
 * 画像の表示サイズを指定した行分のサイズに調整します。デフォルトで８行で設定されていますので８行分の高さを超えたらサイズ調整します。
 * 共通画像、アイテム個別画像で設定可能です。
 * 
 * アイテム、武器、防具の個別画像を表示
 * アイテム、武器、防具のメモ欄
 * <[tag]:[img],[x],[y]> アイテム個別画像の表示
 * [tag]:記述欄、個別指定画像タグ名で設定したタグ名 [img]:画像パス(拡張子なし)
 * 個別指定画像フォルダが'pictures'ならimg/pictures直下のファイルを拡張子なしで記入してください。
 * サブフォルダーから取得する場合はサブフォルダー名も記入してください。例 'items/tankobu'
 * [x]:x座標(相対)
 * [y]:y座標(相対)
 * 複数画像を指定したい場合は項目リストで表示する分だけ設定し、記述欄、個別指定画像タグ名で別々の名前で設定してください。
 * 
 * なおアイテム画像はプラグインパラメータのアイテム画像設定、武器画像設定、防具画像設定からも設定できます。
 * その際、項目設定で個別指定画像(101)を選択していれば画像が表示されます。
 * 上記のタグが記入されている場合は、タグが優先されます。
 * 
 * アイテムに独自のカテゴリーを設定
 * アイテム、武器、防具のメモ欄
 * <[categorytag]:[categorykey]> 表示するアイテムのカテゴリーを記入します。
 * [categorytag]:「カテゴリータグ名」で設定したタグ名
 * [categorykey]:カテゴリーキー
 * allItem:キーアイテムを含む全てのアイテム
 * allItems:アイテム、武器、防具全て
 * 文字の最初と最後の'及び"は付けなくても問題ありませんが、一部の文字列で反映されない場合があるため念のため付いています。
 * メモ欄のタグ記入時では付けないでください。
 * 
 * このプラグインはNUUN_Base Ver.1.3.0以降が必要です。
 * 
 * 更新履歴
 * 2023/1/25 Ver.1.5.1
 * データベースでアイテムカテゴリーを一つに設定したときにアイテム図鑑を開くとエラーが出る問題を修正。
 * アイテムカテゴリーとアイテム図鑑のカテゴリーを別々に仕様変更。
 * 武器の名称のみが適用されない問題を修正。
 * 2023/1/9 Ver.1.5.0
 * アイテム、武器、防具の画像をプラグんパラメータから設定できる機能を追加。
 * 2023/1/7 Ver.1.4.5
 * 項目設定のオリジナルパラメータの仕様を変更。(要オリジナルパラメータのみ再設定)
 * 処理の修正。
 * 2022/7/24 Ver.1.4.4
 * 武器、防具が表示されない問題を修正。
 * 2022/2/3 Ver.1.4.3
 * アイテムのリストの表示がおかしくなる問題を修正。
 * 2021/12/12 Ver.1.4.2
 * メインウィンドウ（アイテムの情報を表示）の横幅を設定できる機能を追加。
 * 2021/11/11 Ver.1.4.1
 * 背景の設定方法を少し変更。
 * 各項目のシステム文字色をカラーコードに対応。
 * 2021/11/3 Ver.1.4.0
 * 完成率ウィンドウに完成率（アイテム、武器、防具）、情報登録数/全アイテム、武器、防具を表示する機能を追加。
 * 2021/9/28 Ver.1.3.0
 * プラグインコマンドに図鑑完成度、情報登録済みアイテム数を変数に代入する機能を追加。
 * ナンバー表示をカテゴリー順に表示させる機能を追加。
 * 背景画像を指定できる機能を追加。
 * 2021/9/2 Ver.1.2.4
 * 個別アイテム画像の座標設定がされていなかった問題を修正。
 * 2021/8/30 Ver.1.2.3
 * プラグインパラメータのアイテム項目設定が初期設定のままだとエラーが出る問題を修正。
 * 2021/8/28 Ver.1.2.2
 * カテゴリーキーが反映しなかった問題を修正。
 * 2021/8/28 Ver.1.2.1
 * 共通画像を空白のままでアイテム図鑑を開くとエラーが出る問題を修正。
 * 2021/8/27 Ver.1.2.0
 * 画像を表示できる機能を追加。
 * 2021/8/22 Ver.1.1.0
 * 任意のアイテムカテゴリーを設定できる機能を追加。
 * 2021/8/13 Ver.1.0.1
 * ブックナンバーの表示がおかしくなる問題を修正。
 * 特定の武器、防具タイプを表示しない機能を追加。
 * 2021/8/11 Ver.1.0.0
 * 初版
 * 
 * @command ItemBookOpen
 * @desc アイテム図鑑を開きます。
 * @text アイテム図鑑を開く
 * 
 * @command ItemBookInfoAdd
 * @desc アイテムを図鑑に追加します。
 * @text アイテム追加
 * 
 * @arg itemId
 * @type item
 * @default 0
 * @desc アイテムIDを指定します。
 * 
 * @command WeaponBookInfoAdd
 * @desc 武器を図鑑に追加します。
 * @text 武器追加
 * 
 * @arg itemId
 * @type weapon
 * @default 0
 * @desc 武器IDを指定します。
 * 
 * @command ArmorBookInfoAdd
 * @desc 防具を図鑑に追加します。
 * @text 防具追加
 * 
 * @arg itemId
 * @type armor
 * @default 0
 * @desc 防具IDを指定します。
 * 
 * @command ItemBookInfoRemove
 * @desc アイテムを図鑑から削除します。
 * @text アイテム削除
 * 
 * @arg itemId
 * @type item
 * @default 0
 * @desc アイテムIDを指定します。
 * 
 * @command WeaponBookInfoRemove
 * @desc 武器を図鑑から削除します。
 * @text 武器削除
 * 
 * @arg itemId
 * @type item
 * @default 0
 * @desc アイテムIDを指定します。
 * 
 * @command ArmorBookInfoRemove
 * @desc 防具を図鑑から削除します。
 * @text 防具削除
 * 
 * @arg itemId
 * @type armor
 * @default 0
 * @desc 防具IDを指定します。
 * 
 * @command ItemBookComplete
 * @desc 図鑑を完成させます。
 * @text 図鑑完成
 * 
 * @command ItemBookCompleteness
 * @desc 図鑑完成率を変数に代入します。
 * @text 図鑑完成率取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookItemCompleteness
 * @desc 図鑑のアイテム完成率を変数に代入します。
 * @text 図鑑アイテム完成率取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookWeaponCompleteness
 * @desc 図鑑の武器完成率を変数に代入します。
 * @text 図鑑武器完成率取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookArmorCompleteness
 * @desc 図鑑の防具完成率を変数に代入します。
 * @text 図鑑防具完成率取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookInfoVar
 * @desc 図鑑情報登録している全てのアイテム（武器、防具含む）の数を変数に代入します。
 * @text 図鑑登録数取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookItemInfoVar
 * @desc 図鑑情報登録しているアイテムの数を変数に代入します。
 * @text 図鑑登録アイテム数取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookWeaponInfoVar
 * @desc 図鑑情報登録している武器数を変数に代入します。
 * @text 図鑑登録武器数取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * @command ItemBookArmorInfoVar
 * @desc 図鑑情報登録している防具数を変数に代入します。
 * @text 図鑑登録防具数取得
 * 
 * @arg VariableId
 * @type variable
 * @default 0
 * @desc 変数
 * 
 * 
 * @param BasicSetting
 * @text 基本設定
 * @default ------------------------------
 * 
 * @param WindowMode
 * @desc アイテム、カテゴリー選択画面の表示位置を指定します。
 * @text 選択画面ウィンドウ位置
 * @type select
 * @option 左側表示
 * @value 0
 * @option 右側表示
 * @value 1
 * @default 0
 * @parent BasicSetting
 * 
 * @param NumberType
 * @text アイテムのナンバー表示
 * @desc アイテムのナンバーを表示します。
 * @type select
 * @option アイテムNoの表示なし
 * @value 0
 * @option アイテムNoを表示する。
 * @value 1
 * @option アイテムNoを表示し、0埋めをする。
 * @value 2
 * @default 0
 * @parent BasicSetting
 * 
 * @param RegistrationTiming
 * @text 登録タイミング
 * @desc 図鑑の登録タイミング。
 * @type select
 * @option 取得時
 * @value 0
 * @option 登録なし
 * @value 10
 * @default 0
 * @parent BasicSetting
 * 
 * @param UnknownData
 * @desc 未確認の索引名です。？1文字だけ入れると名前の文字数に応じて？に置き換えられます。
 * @text 未確認アイテム名
 * @type string
 * @default ？
 * @parent BasicSetting
 * 
 * @param NumberMode
 * @desc ナンバー表示を各カテゴリー表示順で表示します。
 * @text ナンバーカテゴリー表示順表示
 * @type boolean
 * @default false
 * @parent BasicSetting
 * 
 * @param ItemBookImgList
 * @desc アイテムの設定をします。
 * @text アイテム画像設定
 * @type struct<ItemBookList>[]
 * @default 
 * @parent BasicSetting
 * 
 * @param WeaponItemBookImgList
 * @desc 武器の設定をします。
 * @text 武器画像設定
 * @type struct<WeaponItemBookList>[]
 * @default 
 * @parent BasicSetting
 * 
 * @param ArmorItemBookImgList
 * @desc 防具の設定をします。
 * @text 防具画像設定
 * @type struct<ArmorItemBookList>[]
 * @default 
 * @parent BasicSetting
 * 
 * @param ImgFolder
 * @desc 個別指定画像をフォルダ名を指定します。(img直下)
 * @text 個別指定画像フォルダ
 * @type string
 * @default 'pictures'
 * @parent BasicSetting
 * 
 * @param WindowSetting
 * @text ウィンドウ設定
 * @default ------------------------------
 * 
 * @param BookWidth
 * @desc 図鑑のメインウィンドウの横幅。(0で画面の2/3)
 * @text 図鑑の横幅
 * @type number
 * @default 0
 * @min 0
 * @parent WindowSetting
 * 
 * @param BackGround
 * @text 背景設定
 * @default ------------------------------
 * 
 * @param ItemBookBackGround
 * @text 背景画像表示
 * @desc 図鑑の背景画像を表示させます。
 * @type boolean
 * @default false
 * @parent BackGround
 * 
 * @param BackGroundImg
 * @desc 背景画像ファイル名を指定します。
 * @text 背景画像
 * @type file[]
 * @dir img/
 * @default []
 * @parent BackGround
 * 
 * @param BackUiWidth
 * @text 背景サイズをUIに合わせる
 * @desc 背景サイズをUIに合わせる。
 * @type boolean
 * @default true
 * @parent BackGround
 * 
 * @param Category
 * @text カテゴリー設定
 * @default ------------------------------
 * 
 * @param ItemBookCategory
 * @desc アイテムカテゴリーの設定をします。未設定の場合は通常のアイテムカテゴリーが表示されます。
 * @text アイテムカテゴリー設定
 * @type struct<BookCategoryList>[]
 * @default ["{\"CategoryName\":\"アイテム\",\"CategoryKey\":\"[\\\"'allItem'\\\"]\"}","{\"CategoryName\":\"\",\"CategoryKey\":\"[\\\"'weapon'\\\"]\"}","{\"CategoryName\":\"\",\"CategoryKey\":\"[\\\"'armor'\\\"]\"}"]
 * @parent Category
 * 
 * @param ItemBookCategoryTagName
 * @desc メモ欄に記入するアイテムカテゴリー識別用タグの名称を指定します。
 * @type string
 * @default 'CategoryType'
 * @parent Category
 * 
 * @param PercentWindow
 * @text 完成度ウィンドウ設定
 * @default ------------------------------
 * 
 * @param PercentWindowVisible
 * @type boolean
 * @default true
 * @text 完成度ウィンドウ表示
 * @desc 完成度ウィンドウを表示する。
 * @parent PercentWindow
 * 
 * @param PercentContent
 * @desc 完成度ウィンドウの表示項目を設定をします。
 * @text 表示項目設定
 * @type struct<PercentContentList>[]
 * @default ["{\"ContentName\":\"完成度\",\"ContentDate\":\"0\"}"]
 * @parent PercentWindow
 * 
 * @param Interval
 * @desc 完成度ウィンドウの更新フレーム
 * @text 更新フレーム間隔
 * @type number
 * @default 100
 * @max 999999
 * @min 0
 * @parent PercentWindow
 * 
 * @param CommandData
 * @text コマンド設定
 * @default ------------------------------
 * 
 * @param ShowCommand
 * @desc メニューコマンドにアイテム図鑑を追加します。
 * @text メニューコマンド表示
 * @type boolean
 * @default false
 * @parent CommandData
 * 
 * @param CommandName
 * @desc コマンドの名称。
 * @text コマンドの表示名
 * @type string
 * @default アイテム図鑑
 * @parent CommandData
 * 
 * @param itemBookSwitch 
 * @desc 表示させるフラグスイッチID
 * @text メニューコマンド表示スイッチ
 * @type switch
 * @default 0
 * @parent CommandData
 * 
 * @param PageData
 * @text 表示ページ設定
 * @default ------------------------------
 * 
 * @param ItemPageSetting
 * @desc アイテム項目設定。
 * @text アイテム項目設定
 * @type struct<ItemPageSettingData>[]
 * @default ["{\"displayData\":\"[\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"101\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"Itemimg\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"No\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"9\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"disp\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\",\"PageName\":\"\"}"]
 * @parent PageData
 * 
 * @param WeaponPageSetting
 * @desc 武器項目設定。
 * @text 武器項目設定
 * @type struct<WeaponPageSettingData>[]
 * @default ["{\"displayData\":\"[\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"101\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"Itemimg\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"No\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"30\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"32\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"22\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"23\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"25\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"26\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"27\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\",\"PageName\":\"\",\"PageBackGroundId\":\"1\"}"]
 * @parent PageData
 * 
 * @param NoWeaponType
 * @text 表示しない武器タイプ
 * @desc 表示しない武器タイプID。（複数指定化）
 * @type combo[]
 * @default 0
 * @parent PageData
 * 
 * @param ArmorPageSetting
 * @desc 防具項目設定。
 * @text 防具項目設定
 * @type struct<ArmorPageSettingData>[]
 * @default ["{\"displayData\":\"[\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"101\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"Itemimg\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"6\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"center\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"No\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"3\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"31\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"32\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"22\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"23\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"25\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"10\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"26\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"11\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\",\\\"{\\\\\\\"BasicSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramName\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"DateSelect\\\\\\\":\\\\\\\"27\\\\\\\",\\\\\\\"DetaEval\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"NameColor\\\\\\\":\\\\\\\"16\\\\\\\",\\\\\\\"X_Position\\\\\\\":\\\\\\\"2\\\\\\\",\\\\\\\"Y_Position\\\\\\\":\\\\\\\"12\\\\\\\",\\\\\\\"X_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"Y_Coordinate\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"ItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"SystemItemWidth\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"WideMode\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"MaskMode\\\\\\\":\\\\\\\"true\\\\\\\",\\\\\\\"Back\\\\\\\":\\\\\\\"false\\\\\\\",\\\\\\\"nameSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"namePosition\\\\\\\":\\\\\\\"\\\\\\\\\\\\\\\"left\\\\\\\\\\\\\\\"\\\\\\\",\\\\\\\"textSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"textMethod\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"ImgData\\\\\\\":\\\\\\\"[]\\\\\\\",\\\\\\\"ImgMaxHeight\\\\\\\":\\\\\\\"8\\\\\\\",\\\\\\\"UnitSetting\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"paramUnit\\\\\\\":\\\\\\\"\\\\\\\"}\\\"]\",\"PageName\":\"\",\"PageBackGroundId\":\"1\"}"]
 * @parent PageData
 * 
 * @param NoArmorType
 * @text 表示しない防具タイプ
 * @desc 表示しない防具タイプID。（複数指定化）
 * @type combo[]
 * @default 0
 * @parent PageData
 * 
 * @param PageCols
 * @desc ページの最大表示列。
 * @text ページ最大表示列
 * @type number
 * @default 1
 * @min 1
 * @parent PageData
 * 
 * @param ContentCols
 * @text 情報項目列数
 * @desc 情報の項目列数。(全共通)
 * @type select
 * @option ２列
 * @value 2
 * @option ３列
 * @value 3
 * @default 2
 * @parent PageData
 * 
 * 
 */
/*~struct~ItemPageSettingData:
 * 
 * @param displayData
 * @desc 表示するリスト項目。
 * @text 表示項目
 * @type struct<ItemPageListData>[]
 * @default 
 * @parent ListData
 * 
 * @param PageName
 * @desc ページの名前を設定します。
 * @text ページ名
 * @type string
 * @default
 * 
 * @param PageBackGroundId
 * @desc 背景画像を指定します。0の場合はリスト1番の画像が表示されます。
 * @text 背景画像Id
 * @type number
 * @default 1
 *  
 */
/*~struct~WeaponPageSettingData:
 * 
 * @param displayData
 * @desc 表示するリスト項目。
 * @text 表示項目
 * @type struct<WeaponPageListData>[]
 * @default 
 * @parent ListData
 * 
 * @param PageName
 * @desc ページの名前を設定します。
 * @text ページ名
 * @type string
 * @
 * 
 * @param PageBackGroundId
 * @desc 背景画像を指定します。0の場合はリスト1番の画像が表示されます。
 * @text 背景画像Id
 * @type number
 * @default 1
 *  
 */
/*~struct~ArmorPageSettingData:
 * 
 * @param displayData
 * @desc 表示するリスト項目。
 * @text 表示項目
 * @type struct<ArmorPageListData>[]
 * @default 
 * @parent ListData
 * 
 * @param PageName
 * @desc ページの名前を設定します。
 * @text ページ名
 * @type string
 * @default
 * 
 * @param PageBackGroundId
 * @desc 背景画像を指定します。0の場合はリスト1番の画像が表示されます。
 * @text 背景画像Id
 * @type number
 * @default 1
 *  
 */
/*~struct~ItemBookList:
 * 
 * @param Item
 * @desc アイテムを指定します。
 * @text アイテム
 * @type item
 * @default
 * 
 * @param ItemImg
 * @desc アイテムの画像ファイル名を指定します。
 * @text アイテム画像
 * @type file
 * @dir img/
 * @default
 * 
 * @param ItemX
 * @desc 画像の座標X。
 * @text 座標X
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param ItemY
 * @desc 画像の座標Y。
 * @text 座標Y
 * @type number
 * @default 0
 * @min -9999
 *  
 */
/*~struct~WeaponItemBookList:
 * 
 * @param Item
 * @desc アイテムを指定します。
 * @text アイテム
 * @type weapon
 * @default
 * 
 * @param ItemImg
 * @desc 武器の画像ファイル名を指定します。
 * @text 武器画像
 * @type file
 * @dir img/
 * @default
 * 
 * @param ItemX
 * @desc 画像の座標X。
 * @text 座標X
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param ItemY
 * @desc 画像の座標Y。
 * @text 座標Y
 * @type number
 * @default 0
 * @min -9999
 *  
 */
/*~struct~ArmorItemBookList:
 * 
 * @param Item
 * @desc 防具を指定します。
 * @text 防具
 * @type armor
 * @default
 * 
 * @param ItemImg
 * @desc 防具の画像ファイル名を指定します。
 * @text 防具画像
 * @type file
 * @dir img/
 * @default
 * 
 * @param ItemX
 * @desc 画像の座標X。
 * @text 座標X
 * @type number
 * @default 0
 * @min -9999
 * 
 * @param ItemY
 * @desc 画像の座標Y。
 * @text 座標Y
 * @type number
 * @default 0
 * @min -9999
 *  
 */
/*~struct~ItemPageListData:
 * 
 * @param BasicSetting
 * @text 基本設定
 * 
 * @param paramName
 * @desc 表示する項目の名称を設定します。
 * @text 名称
 * @type string
 * @default
 * @parent BasicSetting
 * 
 * @param DateSelect
 * @desc 表示させる項目を指定。
 * @text 項目リスト
 * @type select
 * @option 表示なし
 * @value 0
 * @option アイテム名(2)～(7)(9)(11)
 * @value 1
 * @option ブックナンバー(2)～(7)(9)
 * @value 2
 * @option 所持数(1)～(10)
 * @value 3
 * @option 最大所持数(1)～(10)
 * @value 4
 * @option 価格(1)～(10)
 * @value 5
 * @option オリジナルパラメータ(1)～(10)(15)
 * @value 8
 * @option 記述欄(1)～(7)(9)(12)
 * @value 9
 * @option 使用可能時(1)～(10)
 * @value 10
 * @option 消耗(1)～(10)
 * @value 11
 * @option 速度補正(1)～(10)
 * @value 12
 * @option 成功率(1)～(10)(15)
 * @value 13
 * @option 得TP(1)～(10)
 * @value 14
 * @option 名称のみ(2)～(7)(9)
 * @value 51
 * @option ライン(2)～(7)(9)
 * @value 52
 * @option 取得回数(未実装)
 * @value 60
 * @option 使用回数(未実装)
 * @value 61
 * @option 画像（共通画像）(2)～(7)(9)(13)(14)
 * @value 100
 * @option 画像（個別指定画像）(2)～(7)(9)(12)(14)
 * @value 101
 * @parent BasicSetting
 * 
 * @param DetaEval
 * @desc パラメータ評価式を設定します。
 * @text パラメータ評価式(1)
 * @type combo
 * @option '$gameVariables.value(0);//ゲーム変数'
 * @default 
 * @parent BasicSetting
 * 
 * @param NameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(2)
 * @type number
 * @default 16
 * @min 0
 * @parent BasicSetting
 * 
 * @param X_Position
 * @text X表示列位置(3)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 3
 * @parent BasicSetting
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(4)
 * @type number
 * @default 1
 * @min 1
 * @max 9999
 * @parent BasicSetting
 * 
 * @param X_Coordinate
 * @text X座標（相対）(5)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(6)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param ItemWidth
 * @desc 項目横幅（0で自動）
 * @text 項目横幅(7)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param SystemItemWidth
 * @desc システム項目の横幅（0でデフォルト幅）
 * @text システム項目横幅(8)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param WideMode
 * @desc 項目表示モード
 * @text 項目表示モード(9)
 * @type select
 * @option １列表示
 * @value 1
 * @option ２列表示
 * @value 2
 * @option ３列表示（表示列数が３の時のみ）
 * @value 3
 * @default 1
 * @parent BasicSetting
 * 
 * @param Back
 * @text コンテンツ背景表示(10)
 * @desc コンテンツ背景を表示させます。
 * @type boolean
 * @default false
 * @parent BasicSetting
 * 
 * @param nameSetting
 * @text 名称、アイテム名設定
 * 
 * @param namePosition
 * @desc 名称、アイテム名の表示位置を指定します
 * @text 名称、アイテム名表示位置(11)
 * @type select
 * @option 左
 * @value "left"
 * @option 中央
 * @value "center"
 * @option 右
 * @value "raight"
 * @default "left"
 * @parent nameSetting
 * 
 * @param textSetting
 * @text 記述欄設定
 * 
 * @param textMethod
 * @desc 記述欄、画像（個別指定画像）に紐づけするタグ名
 * @text 記述欄、個別指定画像タグ名(12)
 * @type string
 * @default 
 * @parent textSetting
 * 
 * @param ImgSetting
 * @text 画像設定
 * 
 * @param ImgData
 * @desc 画像ファイル名を指定します。
 * @text 画像(13)
 * @type file[]
 * @dir img/
 * @default []
 * @parent ImgSetting
 * 
 * @param ImgMaxHeight
 * @desc 画像の最大縦幅（行数で指定）
 * @text 画像の最大縦幅(14)
 * @type number
 * @default 8
 * @min 0
 * @parent ImgSetting
 * 
 * @param UnitSetting
 * @text 単位設定
 * 
 * @param paramUnit
 * @desc 単位を設定します。
 * @text 単位(15)
 * @type string
 * @default 
 * @parent UnitSetting
 * 
 * 
 */
/*~struct~WeaponPageListData:
 * 
 * @param BasicSetting
 * @text 基本設定
 * 
 * @param paramName
 * @desc 表示する項目の名称を設定します。
 * @text 名称
 * @type string
 * @default
 * @parent BasicSetting
 * 
 * @param DateSelect
 * @desc 表示させる項目を指定。
 * @text 項目リスト
 * @type select
 * @option 表示なし
 * @value 0
 * @option 武器名(2)～(7)(9)(11)
 * @value 1
 * @option ブックナンバー(2)～(7)(9)
 * @value 2
 * @option 所持数(1)～(10)
 * @value 3
 * @option 最大所持数(1)～(10)
 * @value 4
 * @option 価格(1)～(10)
 * @value 5
 * @option オリジナルパラメータ(1)～(10)(15)
 * @value 8
 * @option 記述欄(1)～(7)(9)(12)
 * @value 9
 * @option HP(1)～(10)
 * @value 20
 * @option MP(1)～(10)
 * @value 21
 * @option 攻撃力(1)～(10)
 * @value 22
 * @option 防御力(1)～(10)
 * @value 23
 * @option 魔力(1)～(10)
 * @value 24
 * @option 魔法防御(1)～(10)
 * @value 25
 * @option 敏捷性(1)～(10)
 * @value 26
 * @option 運(1)～(10)
 * @value 27
 * @option 武器タイプ(1)～(10)
 * @value 30
 * @option 装備タイプ(1)～(10)
 * @value 32
 * @option 名称のみ(2)～(7)(9)
 * @value 51
 * @option ライン(2)～(7)(9)
 * @value 52
 * @option 取得回数（未実装）
 * @value 60
 * @option 画像（共通画像）(2)～(7)(9)(13)(14)
 * @value 100
 * @option 画像（個別指定画像）(2)～(7)(9)(12)(14)
 * @value 101
 * @parent BasicSetting
 * 
 * @param DetaEval
 * @desc パラメータ評価式を設定します。
 * @text パラメータ評価式(1)
 * @type combo
 * @option '$gameVariables.value(0);//ゲーム変数'
 * @default 
 * @parent BasicSetting
 * 
 * @param NameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(2)
 * @type number
 * @default 16
 * @min 0
 * @parent BasicSetting
 * 
 * @param X_Position
 * @text X表示列位置(3)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 3
 * @parent BasicSetting
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(4)
 * @type number
 * @default 1
 * @max 9999
 * @min 1
 * @parent BasicSetting
 * 
 * @param X_Coordinate
 * @text X座標（相対）(5)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(6)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param ItemWidth
 * @desc 項目横幅（0で自動）
 * @text 項目横幅(7)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param SystemItemWidth
 * @desc システム項目の横幅（0でデフォルト幅）
 * @text システム項目横幅(8)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param WideMode
 * @desc 項目表示モード
 * @text 項目表示モード(9)
 * @type select
 * @option １列表示
 * @value 1
 * @option ２列表示
 * @value 2
 * @option ３列表示（表示列数が３の時のみ）
 * @value 3
 * @default 1
 * @parent BasicSetting
 * 
 * @param Back
 * @text コンテンツ背景表示(10)
 * @desc コンテンツ背景を表示させます。
 * @type boolean
 * @default false
 * @parent BasicSetting
 * 
 * @param ParamId
 * @desc IDを設定します。
 * @text ID(16)
 * @type number
 * @default 
 * @parent BasicSetting
 * 
 * @param nameSetting
 * @text 名称、アイテム名設定
 * 
 * @param namePosition
 * @desc 名称、アイテム名の表示位置を指定します
 * @text 名称、アイテム名表示位置(11)
 * @type select
 * @option 左
 * @value "left"
 * @option 中央
 * @value "center"
 * @option 右
 * @value "raight"
 * @default "left"
 * @parent nameSetting
 * 
 * @param textSetting
 * @text 記述欄設定
 * 
 * @param textMethod
 * @desc 記述欄、画像（個別指定画像）に紐づけするタグ名
 * @text 記述欄、個別指定画像タグ名(12)
 * @type string
 * @default 
 * @parent textSetting
 * 
 * @param ImgSetting
 * @text 画像設定
 * 
 * @param ImgData
 * @desc 共通画像ファイル名を指定します。
 * @text 共通画像(13)
 * @type file[]
 * @dir img/
 * @default []
 * @parent ImgSetting
 * 
 * @param ImgMaxHeight
 * @desc 画像の最大縦幅（行数で指定）
 * @text 画像の最大縦幅(14)
 * @type number
 * @default 8
 * @min 0
 * @parent ImgSetting
 * 
 * @param UnitSetting
 * @text 単位設定
 * 
 * @param paramUnit
 * @desc 単位を設定します。
 * @text 単位(15)
 * @type string
 * @default 
 * @parent UnitSetting
 * 
 * 
 */
/*~struct~ArmorPageListData:
 * 
 * @param BasicSetting
 * @text 基本設定
 * 
 * @param paramName
 * @desc 表示する項目の名称を設定します。
 * @text 名称
 * @type string
 * @default
 * @parent BasicSetting
 * 
 * @param DateSelect
 * @desc 表示させる項目を指定。
 * @text 項目リスト
 * @type select
 * @option 表示なし
 * @value 0
 * @option 武器名(2)～(7)(9)(11)
 * @value 1
 * @option ブックナンバー(2)～(7)(9)
 * @value 2
 * @option 所持数(1)～(10)
 * @value 3
 * @option 最大所持数(1)～(10)
 * @value 4
 * @option 価格(1)～(10)
 * @value 5
 * @option オリジナルパラメータ(1)～(10)(15)
 * @value 8
 * @option 記述欄(1)～(7)(9)(12)
 * @value 9
 * @option HP(1)～(10)
 * @value 20
 * @option MP(1)～(10)
 * @value 21
 * @option 攻撃力(1)～(10)
 * @value 22
 * @option 防御力(1)～(10)
 * @value 23
 * @option 魔力(1)～(10)
 * @value 24
 * @option 魔法防御(1)～(10)
 * @value 25
 * @option 敏捷性(1)～(10)
 * @value 26
 * @option 運(1)～(10)
 * @value 27
 * @option 防具タイプ(1)～(10)
 * @value 31
 * @option 装備タイプ(1)～(10)
 * @value 32
 * @option 名称のみ(2)～(7)(9)
 * @value 51
 * @option ライン(2)～(7)(9)
 * @value 52
 * @option 取得回数(未実装)
 * @value 60
 * @option 画像（共通画像）(2)～(7)(9)(13)(14)
 * @value 100
 * @option 画像（個別指定画像）(2)～(7)(9)(12)(14)
 * @value 101
 * @parent BasicSetting
 * 
 * @param DetaEval
 * @desc パラメータ評価式を設定します。
 * @text パラメータ評価式(1)
 * @type combo
 * @option '$gameVariables.value(0);//ゲーム変数'
 * @default 
 * @parent BasicSetting
 * 
 * @param NameColor
 * @desc システム項目の文字色。テキストタブでカラーコードを入力できます。
 * @text システム項目文字色(2)
 * @type number
 * @default 16
 * @min 0
 * @parent BasicSetting
 * 
 * @param X_Position
 * @text X表示列位置(3)
 * @desc X表示列位置
 * @type number
 * @default 1
 * @min 1
 * @max 3
 * @parent BasicSetting
 * 
 * @param Y_Position
 * @desc Y表示行位置
 * @text Y表示行位置(4)
 * @type number
 * @default 1
 * @max 9999
 * @min 1
 * @parent BasicSetting
 * 
 * @param X_Coordinate
 * @text X座標（相対）(5)
 * @desc X座標（X表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param Y_Coordinate
 * @text Y座標（相対）(6)
 * @desc Y座標（Y表示列位置からの相対座標）
 * @type number
 * @default 0
 * @min -9999
 * @parent BasicSetting
 * 
 * @param ItemWidth
 * @desc 項目横幅（0で自動）
 * @text 項目横幅(7)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param SystemItemWidth
 * @desc システム項目の横幅（0でデフォルト幅）
 * @text システム項目横幅(8)
 * @type number
 * @default 0
 * @min 0
 * @parent BasicSetting
 * 
 * @param WideMode
 * @desc 項目表示モード
 * @text 項目表示モード(9)
 * @type select
 * @option １列表示
 * @value 1
 * @option ２列表示
 * @value 2
 * @option ３列表示（表示列数が３の時のみ）
 * @value 3
 * @default 1
 * @parent BasicSetting
 * 
 * @param Back
 * @text コンテンツ背景表示(10)
 * @desc コンテンツ背景を表示させます。
 * @type boolean
 * @default false
 * @parent BasicSetting
 * 
 * @param ParamId
 * @desc IDを設定します。
 * @text ID(16)
 * @type number
 * @default 
 * @parent BasicSetting
 * 
 * @param nameSetting
 * @text 名称、アイテム名設定
 * 
 * @param namePosition
 * @desc 名称、アイテム名の表示位置を指定します
 * @text 名称、アイテム名表示位置(11)
 * @type select
 * @option 左
 * @value "left"
 * @option 中央
 * @value "center"
 * @option 右
 * @value "raight"
 * @default "left"
 * @parent nameSetting
 * 
 * @param textSetting
 * @text 記述欄設定
 * 
 * @param textMethod
 * @desc 記述欄、画像（個別指定画像）に紐づけするタグ名
 * @text 記述欄、個別指定画像タグ名(12)
 * @type string
 * @default 
 * @parent textSetting
 * 
 * @param ImgSetting
 * @text 画像設定
 * 
 * @param ImgData
 * @desc 共通画像ファイル名を指定します。
 * @text 共通画像(13)
 * @type file[]
 * @dir img/
 * @default []
 * @parent ImgSetting
 * 
 * @param ImgMaxHeight
 * @desc 画像の最大縦幅（行数で指定）
 * @text 画像の最大縦幅(14)
 * @type number
 * @default 8
 * @min 0
 * @parent ImgSetting
 * 
 * @param UnitSetting
 * @text 単位設定
 * 
 * @param paramUnit
 * @desc 単位を設定します。
 * @text 単位(15)
 * @type string
 * @default 
 * @parent UnitSetting
 * 
 * 
 */
/*~struct~PercentContentList:
 *
 * @param ContentName
 * @desc 名称。
 * @text 表示名称
 * @type string
 * @default 
 * 
 * @param ContentDate
 * @desc 表示する
 * @text 名称、アイテム名表示位置
 * @type select
 * @option 図鑑完成率
 * @value 0
 * @option 図鑑アイテム完成率
 * @value 1
 * @option 図鑑武器完成率
 * @value 2
 * @option 図鑑防具完成率
 * @value 3
 * @option 図鑑登録数(登録数/全アイテム、武器、防具)
 * @value 10
 * @option 図鑑アイテム登録数(登録数/全アイテム)
 * @value 11
 * @option 図鑑武器登録数(登録数/全武器)
 * @value 12
 * @option 図鑑防具登録数(登録数/全防具)
 * @value 13
 * @default 0
 * @parent nameSetting
*
*/
/*~struct~BookCategoryList:
 * 
 * @param CategoryName
 * @desc カテゴリー名を設定します。
 * @text カテゴリー名
 * @type string
 * 
 * @param CategoryKey
 * @text カテゴリーKey
 * @desc カテゴリーのKeyを設定します。(１番目のみ入力)
 * @type combo[]
 * @option 'item'
 * @option 'allItem'
 * @option 'keyItem'
 * @option 'weapon'
 * @option 'armor'
 * @option 'allItems'
 * @default
 */
var Imported = Imported || {};
Imported.NUUN_ItemBook = true;

(() => {
const parameters = PluginManager.parameters('NUUN_ItemBook');
const WindowMode = Number(parameters['WindowMode'] || 0);
const NumberType = Number(parameters['NumberType'] || 0);
const RegistrationTiming = Number(parameters['RegistrationTiming'] || 0);
const BookWidth = Number(parameters['BookWidth'] || 0);
const RegistrationItemTiming = Number(parameters['RegistrationItemTiming'] || 0);
const UnknownData = String(parameters['UnknownData'] || '？');
const UnknownItemData = String(parameters['UnknownItemData'] || '？？？');
const ItemBookImgList = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['ItemBookImgList'])) : null) || [];
const WeaponItemBookImgList = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['WeaponItemBookImgList'])) : null) || [];
const ArmorItemBookImgList = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['ArmorItemBookImgList'])) : null) || [];
const ImgFolder = eval(parameters['ImgFolder'] || 'pictures');
let PercentWindowVisible = eval(parameters['PercentWindowVisible'] || 'true');
const NumberMode = eval(parameters['NumberMode'] || "false");
const PercentContent = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['PercentContent'])) : null) || [];
const Interval = Number(parameters['Interval'] || 100);
const ShowCommand = eval(parameters['ShowCommand'] || 'false');
const CommandName = String(parameters['CommandName'] || 'アイテム図鑑');
const itemBookSwitch = Number(parameters['itemBookSwitch'] || 0);
const ItemPageSetting = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['ItemPageSetting'])) : null) || [];
const WeaponPageSetting = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['WeaponPageSetting'])) : null) || [];
const ArmorPageSetting = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['ArmorPageSetting'])) : null) || [];
const PageCols = Number(parameters['PageCols'] || 1);
const NoWeaponType = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['NoWeaponType'])) : null) || [0];
const NoArmorType = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['NoArmorType'])) : null) || [0];
const ContentCols = Number(parameters['ContentCols'] || 2);
const EffectMaxItems = Number(parameters['EffectMaxItems'] || 0);
const EffectMultiCol = eval(parameters['EffectMultiCol'] || "false");
const TraitsMaxItems = Number(parameters['TraitsMaxItems'] || 0);
const TraitsMultiCol = eval(parameters['TraitsMultiCol'] || "false");
const BackGroundImg = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['BackGroundImg'])) : null) || [];
const ItemBookCategory = (NUUN_Base_Ver >= 113 ? (DataManager.nuun_structureData(parameters['ItemBookCategory'])) : null) || [];
const ItemBookCategoryTagName = eval(parameters['ItemBookCategoryTagName'] || 'CategoryType');
const ItemBookBackGround = eval(parameters['ItemBookBackGround'] || "false");
const BackUiWidth = eval(parameters['BackUiWidth'] || "false");

const PercentContentLength = PercentWindowVisible && (PercentContent && PercentContent.length > 0);
let backGroundId = -1;

const pluginName = "NUUN_ItemBook";

PluginManager.registerCommand(pluginName, 'ItemBookOpen', args => {
  if ($gameParty.inBattle()) {
    
  } else {
    SceneManager.push(Scene_ItemBook);
  }
});

PluginManager.registerCommand(pluginName, 'ItemBookAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookFlags($dataItems[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'WeaponBookAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookFlags($dataWeapons[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ArmorBookAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookFlags($dataArmors[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ItemBookInfoAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookInfoFlags($dataItems[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'WeaponBookInfoAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookInfoFlags($dataWeapons[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ArmorBookInfoAdd', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.setItemBookInfoFlags($dataArmors[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ItemBookInfoRemove', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.removeItemBookInfoFlags($dataItems[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'WeaponBookInfoRemove', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.removeItemBookInfoFlags($dataWeapons[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ArmorBookInfoRemove', args => {
  const itemId = Number(args.itemId);
  if (itemId > 0) {
    $gameSystem.removeItemBookInfoFlags($dataArmors[itemId]);
  }
});

PluginManager.registerCommand(pluginName, 'ItemBookComplete', args => {
  $gameSystem.completeItemBook();
});

PluginManager.registerCommand(pluginName, 'ItemBookCompleteness', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessPercent('all'));
});

PluginManager.registerCommand(pluginName, 'ItemBookItemCompleteness', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessPercent('item'));
});

PluginManager.registerCommand(pluginName, 'ItemBookWeaponCompleteness', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessPercent('weapon'));
});

PluginManager.registerCommand(pluginName, 'ItemBookArmorCompleteness', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessPercent('armor'));
});

PluginManager.registerCommand(pluginName, 'ItemBookInfoVar', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessItemNum('all'));
});

PluginManager.registerCommand(pluginName, 'ItemBookItemInfoVar', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessItemNum('item'));
});

PluginManager.registerCommand(pluginName, 'ItemBookWeaponsInfoVar', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessItemNum('weapon'));
});

PluginManager.registerCommand(pluginName, 'ItemBookArmorInfoVar', args => {
  $gameVariables.setValue(Number(args.VariableId), $gameSystem.getCompletenessItemNum('armor'));
});


function getAllItemData() {
  let list = [];
  Array.prototype.push.apply(list, $dataItems);
  Array.prototype.push.apply(list, $dataWeapons);
  Array.prototype.push.apply(list, $dataArmors);
  return list;
  //return $dataItems.concat($dataWeapons, $dataArmors);
};

function getItemData(mode) {
  if (mode === 'all') {
    return getAllItemData();
  } else if (mode === 'item') {
    return $dataItems;
  } else if (mode === 'weapon') {
    return $dataWeapons;
  } else if (mode === 'armor') {
    return $dataArmors;
  } else {
    return [];
  }
}


const _DataManager_extractSaveContents = DataManager.extractSaveContents;
DataManager.extractSaveContents = function(contents) {
  _DataManager_extractSaveContents.call(this, contents);
  $gameSystem.initItemBookNumber();
};

const _Game_System_initialize = Game_System.prototype.initialize;
Game_System.prototype.initialize = function() {
  _Game_System_initialize.call(this);
  this.clearItemBookFlags();
  this.initItemBookNumber();
};

Game_System.prototype.clearItemBookFlags = function() {
  this._itembookData = {};
};

Game_System.prototype.ItemBookType = function(item) {
  if (DataManager.isItem(item)) {
    return 0;
  } else if (DataManager.isWeapon(item)) {
    return 1;
  } else if (DataManager.isArmor(item)) {
    return 2;
  }
  return -1;
};

Game_System.prototype.setItemBook = function(mode, itemId, data) {
  if(!this._itembookData) {
    this.clearItemBookFlags();
  }
  const a = this._itembookData
  switch (mode) {
    case "itemFlag":
      if (!a._itembookItemData) {
        a._itembookItemData = [];
      }
      a._itembookItemData[itemId] = data;
    break;
    case "weaponFlag":
      if (!a._itembookWeaponData) {
        a._itembookWeaponData = [];
      }
      a._itembookWeaponData[itemId] = data;
      break;
    case "armorFlag":
      if (!a._itembookArmorData) {
        a._itembookArmorData = [];
      }
      a._itembookArmorData[itemId] = data;
      break;
    case "itemInfoFlag":
      if (!a._itembookItemInfo) {
        a._itembookItemInfo = [];
      }
      a._itembookItemInfo[itemId] = data;
      break;
    case "weaponInfoFlag":
      if (!a._itembookWeaponInfo) {
        a._itembookWeaponInfo = [];
      }
      a._itembookWeaponInfo[itemId] = data;
      break;
    case "armorInfoFlag":
      if (!a._itembookArmorInfo) {
        a._itembookArmorInfo = [];
      }
      a._itembookArmorInfo[itemId] = data;
      break;
    case "itemBookNumber":
      if (!a._itemBookNumber) {
        a._itemBookNumber = [];
      }
      a._itemBookNumber[itemId] = data;
    case "weaponBookNumber":
      if (!a._weaponBookNumber) {
        a._weaponBookNumber = [];
      }
      a._weaponBookNumber[itemId] = data;
    case "armorBookNumber":
      if (!a._armorBookNumber) {
        a._armorBookNumber = [];
      }
      a._armorBookNumber[itemId] = data;
  }
};

Game_System.prototype.setItemBookFlags = function(item) {
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    this.setItemBook("itemFlag", item.id, true);
  } else if (itemType === 1) {
    this.setItemBook("weaponFlag", item.id, true);
  } else if (itemType === 2) {
    this.setItemBook("armorFlag", item.id, true);
  }
};

Game_System.prototype.getItemBookFlags = function(item) {
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    return this._itembookData._itembookItemData ? this._itembookData._itembookItemData[item.id] : false;
  } else if (itemType === 1) {
    return this._itembookData._itembookWeaponData ? this._itembookData._itembookWeaponData[item.id] : false;
  } else if (itemType === 2) {
    return this._itembookData._itembookArmorData ? this._itembookData._itembookArmorData[item.id] : false;
  }
  return false;
};

Game_System.prototype.setItemBookInfoFlags = function(item) {
  this.setItemBookFlags(item);
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    this.setItemBook("itemInfoFlag", item.id, true);
  } else if (itemType === 1) {
    this.setItemBook("weaponInfoFlag", item.id, true);
  } else if (itemType === 2) {
    this.setItemBook("armorInfoFlag", item.id, true);
  }
};

Game_System.prototype.getItemBookInfoFlags = function(item) {
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    return this._itembookData._itembookItemInfo ? this._itembookData._itembookItemInfo[item.id] : false;
  } else if (itemType === 1) {
    return this._itembookData._itembookWeaponInfo ? this._itembookData._itembookWeaponInfo[item.id] : false;
  } else if (itemType === 2) {
    return this._itembookData._itembookArmorInfo ? this._itembookData._itembookArmorInfo[item.id] : false;
  }
};

Game_System.prototype.removeItemBookFlags = function(item) {
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    this.setItemBook("itemFlag", item.id, false);
  } else if (itemType === 1) {
    this.setItemBook("weaponFlag", item.id, false);
  } else if (itemType === 2) {
    this.setItemBook("armorFlag", item.id, false);
  }
};

Game_System.prototype.removeItemBookInfoFlags = function(item) {
  this.removeItemBookFlags(item);
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    this.setItemBook("itemInfoFlag", item.id, false);
  } else if (itemType === 1) {
    this.setItemBook("weaponInfoFlag", item.id, false);
  } else if (itemType === 2) {
    this.setItemBook("armorInfoFlag", item.id, false);
  }
};

Game_System.prototype.initItemBookNumber = function() {
  if(!this._itembookData) {
    this.clearItemBookFlags();
  }
  this._itembookData._itemBookNumber = [];
  this._itembookData._itemBookWeaponNumber = [];
  this._itembookData._itemBookArmorNumber = [];
  let index = 0;
  for (item of $dataItems) {
    if (item && this.isItemBook(item)) {
      index++;
      this._itembookData._itemBookNumber.push(index);
    } else {
      this._itembookData._itemBookNumber.push(-1);
    }
  }
  this._itembookData._itemBookItemLength = index;
  index = 0;
  for (item of $dataWeapons) {
    if (item && this.isItemBook(item)) {
      index++;
      this._itembookData._itemBookWeaponNumber.push(index);
    } else {
      this._itembookData._itemBookWeaponNumber.push(-1);
    }
  }
  this._itembookData._itemBookWeaponLength = index;
  index = 0;
  for (item of $dataArmors) {
    if (item && this.isItemBook(item)) {
      index++;
      this._itembookData._itemBookArmorNumber.push(index);
    } else {
      this._itembookData._itemBookArmorNumber.push(-1);
    }
  }
  this._itembookData._itemBookArmorLength = index;
};

Game_System.prototype.typeIncludes = function(item) {
  if (DataManager.isItem(item)) {
    return item.itypeId <= 2;
  } else if (DataManager.isWeapon(item)) {
    return !NoWeaponType.some(type => Number(type) === item.wtypeId);
  } else if (DataManager.isArmor(item)) {
    return !NoArmorType.some(type => Number(type) === item.atypeId);
  }
  return true;
};

Game_System.prototype.getItemBookNumber = function(item) {
  const itemType = this.ItemBookType(item);
  if (itemType === 0) {
    return this._itembookData._itemBookNumber ? this._itembookData._itemBookNumber[item.id] : 0;
  } else if (itemType === 1) {
    return this._itembookData._itemBookWeaponNumber ? this._itembookData._itemBookWeaponNumber[item.id] : 0;
  } else if (itemType === 2) {
    return this._itembookData._itemBookArmorNumber ? this._itembookData._itemBookArmorNumber[item.id] : 0;
  }
  return 0;
};

Game_System.prototype.completeItemBook = function() {
  for (const item of $dataItems) {
    this.setItemBookInfoFlags(item);
  }
  for (const item of $dataWeapons) {
    this.setItemBookInfoFlags(item);
  }
  for (const item of $dataArmors) {
    this.setItemBookInfoFlags(item);
  }
};

Game_System.prototype.clearEnemyBook = function() {
  for (const item of $dataItems) {
    this.removeItemBookInfoFlags(item);
  }
  for (const item of $dataWeapons) {
    this.removeItemBookInfoFlags(item);
  }
  for (const item of $dataArmors) {
    this.removeItemBookInfoFlags(item);
  }
};

Game_System.prototype.isInItemBook = function(item) {
  return item && item.name && this.getItemBookFlags(item);
};

Game_System.prototype.isInItemBookStatus = function(item) {
  return item && item.name && this.getItemBookInfoFlags(item);
};

Game_System.prototype.isItemBook = function(item) {//データベース
  return item && item.name && !item.meta.NoBook && this.typeIncludes(item);
};

Game_System.prototype.getItemBookFlagsNum = function(itemList) {
  return itemList.reduce((r, item) => r + (this.isItemBook(item) && this.isInItemBook(item) ? 1 : 0), 0);
};

Game_System.prototype.getItemBookInfoFlagsNum = function(itemList) {
  return itemList.reduce((r, item) => r + (this.isItemBook(item) && this.isInItemBookStatus(item) ? 1 : 0), 0);
};

Game_System.prototype.getIsItemBook = function(itemList) {
  return itemList.filter(item => this.isItemBook(item));
};

Game_System.prototype.getCompletenessPercent = function(mode) {
  const bookItems = this.getIsItemBook(getItemData(mode));
  const onData = this.getItemBookInfoFlagsNum(bookItems);
  return Math.floor(onData / bookItems.length * 100);
};

Game_System.prototype.getCompletenessItemNum = function(mode) {
  const bookItems = this.getIsItemBook(getItemData(mode));
  return this.getItemBookInfoFlagsNum(bookItems);
};


const _Game_Actor_initEquips = Game_Actor.prototype.initEquips;
Game_Actor.prototype.initEquips = function(equips) {
  _Game_Actor_initEquips.call(this, equips);
  for (const equip of this._equips) {
    if (equip.object()) {
      if (RegistrationItemTiming === 0) {
        $gameSystem.setItemBookInfoFlags(equip.object());
      }
    }
  }
};

const _Game_Party_consumeItem = Game_Party.prototype.consumeItem;
Game_Party.prototype.consumeItem = function(item) {
  _Game_Party_consumeItem.call(this, item);
  if (RegistrationTiming === 1) {
    //$gameSystem.setItemBookFlags():
  }
};

const _Game_Party_gainItem = Game_Party.prototype.gainItem;
Game_Party.prototype.gainItem = function(item, amount, includeEquip) {
  if (amount > 0) {
    if (RegistrationTiming === 0) {
      $gameSystem.setItemBookFlags(item);
    }
    if (RegistrationItemTiming === 0) {
      $gameSystem.setItemBookInfoFlags(item);
    }
  }
  _Game_Party_gainItem.call(this, item, amount, includeEquip);
};

const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
Window_MenuCommand.prototype.addOriginalCommands = function() {
  _Window_MenuCommand_addOriginalCommands.call(this);
  if(ShowCommand && ($gameSwitches.value(itemBookSwitch) || itemBookSwitch === 0)) {
    this.addCommand(CommandName, "itemBook");
  }
};


const _Scene_Menu_createCommandWindow =　Scene_Menu.prototype.createCommandWindow;
Scene_Menu.prototype.createCommandWindow = function() {
  _Scene_Menu_createCommandWindow.call(this);
    this._commandWindow.setHandler("itemBook", this.commandItemBook.bind(this));
};

Scene_Menu.prototype.commandItemBook = function() {
  SceneManager.push(Scene_ItemBook);
};


function Scene_ItemBook() {
  this.initialize(...arguments);
}

Scene_ItemBook.prototype = Object.create(Scene_MenuBase.prototype);
Scene_ItemBook.prototype.constructor = Scene_ItemBook;

Scene_ItemBook.prototype.initialize = function() {
  Scene_MenuBase.prototype.initialize.call(this);
};

Scene_ItemBook.prototype.create = function() {
  Scene_MenuBase.prototype.create.call(this);
  this.createHelpWindow();
  this.createPercentWindow();
  this.createIndexWindow();
  this.createItemPageWindow();
  this.createItemWindow();
  this.createCategoryWindow();
  this.backgroundOpacity(this._helpWindow);
};

Scene_ItemBook.prototype.createPercentWindow = function() {
  if (PercentContentLength) {
    const rect = this.percentWindowRect();
    this._percentWindow = new Window_ItemBook_Percent(rect);
    this.addWindow(this._percentWindow);
    this.backgroundOpacity(this._percentWindow);
  }
};

Scene_ItemBook.prototype.createIndexWindow = function() {
  const rect = this.indexWindowRect();
  this._indexWindow = new Window_ItemBook_Index(rect);
  this.addWindow(this._indexWindow);
  this._indexWindow.setHandler("cancel", this.onItemIndexCancel.bind(this));
  this._indexWindow.hide();
  this.backgroundOpacity(this._indexWindow);
};

Scene_ItemBook.prototype.createCategoryWindow = function() {
  const rect = this.indexWindowRect();
  this._categoryWindow = new Window_ItemBook_Category(rect);
  this._categoryWindow.setHandler("cancel", this.popScene.bind(this));
  this._categoryWindow.setHandler("ok", this.onCategoryOk.bind(this));
  this.addWindow(this._categoryWindow);
  this._categoryWindow.activate();
  this._categoryWindow.setItemWindow(this._indexWindow);
  this._itemPageWindow.deselect();
  this._itemPageWindow.deactivate();
  this._indexWindow.setCategoryWindow(this._categoryWindow);
  this._indexWindow.setPercentWindow(this._percentWindow);
  if (!this._categoryWindow.needsSelection()) {
    this._categoryWindow.update();
    this._categoryWindow.hide();
    this.onCategoryOk();
  }
  this.backgroundOpacity(this._categoryWindow);
};

Scene_ItemBook.prototype.createItemWindow = function() {
  const rect = this.itemWindowRect();
  this._itembookWindow = new Window_ItemBook(rect);
  this.addWindow(this._itembookWindow);
  this._indexWindow.setItemWindow(this._itembookWindow);
  this._itemPageWindow.setItemWindow(this._itembookWindow);
  this._indexWindow.select(Window_ItemBook_Index._lastIndex);
  this._itembookWindow.setHelpWindow(this._helpWindow);
  this.backgroundOpacity(this._itembookWindow);
  this.setMaxPage(ItemPageSetting);
};

Scene_ItemBook.prototype.createItemPageWindow = function() {
  const rect = this.itemWindowPageRect();
  this._itemPageWindow = new Window_ItemBookPageCategory(rect);
  this.addWindow(this._itemPageWindow);
  this._itemPageWindow.setIndexWindow(this._indexWindow);
  this._indexWindow.setPageWindow(this._itemPageWindow);
  if (PageCols <= 1) {
    this._itemPageWindow.height = 0;
    this._itemPageWindow.hide();
  }
  this.backgroundOpacity(this._itemPageWindow);
};

Scene_ItemBook.prototype.percentWindowRect = function() {
  const wx = WindowMode === 0 ? 0 : this.itemWindowWidth();
  const wy = this.mainAreaTop();
  const ww = this.indexWidth();
  const wh = PercentContentLength ? this.calcWindowHeight(1, true) : 0;
  return new Rectangle(wx, wy, ww, wh);
};

Scene_ItemBook.prototype.indexWindowRect = function() {
  const height = this.percentWindowRect().height;
  const wx = WindowMode === 0 ? 0 : this.itemWindowWidth();
  const wy = this.mainAreaTop() + height;
  const ww = this.indexWidth();
  const wh = this.mainAreaHeight() - height;
  return new Rectangle(wx, wy, ww, wh);
};

Scene_ItemBook.prototype.itemWindowPageRect = function() {
  const wx = WindowMode === 0 ? this.indexWidth() : 0;
  const wy = this.mainAreaTop();
  const ww = this.itemWindowWidth();
  const wh = this.calcWindowHeight(1, true);
  return new Rectangle(wx, wy, ww, wh);
};

Scene_ItemBook.prototype.itemWindowRect = function() {
  const wx = WindowMode === 0 ? this.indexWidth() : 0;
  const wy = this.mainAreaTop() + this._itemPageWindow.height;
  const ww = this.itemWindowWidth();
  const wh = this.mainAreaHeight() - this._itemPageWindow.height;
  return new Rectangle(wx, wy, ww, wh);
};

Scene_ItemBook.prototype.indexWidth = function() {
  return BookWidth > 0 ? Graphics.boxWidth - BookWidth : Math.floor(Graphics.boxWidth / 3);
};


Scene_ItemBook.prototype.backgroundOpacity = function(window) {
  if (ItemBookBackGround) {
    window.opacity = 0;
  }
};

Scene_ItemBook.prototype.itemWindowWidth = function() {
  return Graphics.boxWidth - this.indexWidth();
};

Scene_ItemBook.prototype.setMaxPage = function(page) {
  page = page || [];
  this._maxPage = page.length;
  this._itembookWindow.displayList = page;
};

Scene_ItemBook.prototype.onItemIndexCancel = function() {
  if (this._categoryWindow.needsSelection()) {
    this._categoryWindow.setSelect();
    this._categoryWindow.show();
    this._categoryWindow.activate();
    this._indexWindow.hide();
    this._indexWindow.deselect();
    this._indexWindow.deactivate();
    this._itemPageWindow.deselect();
    this._itemPageWindow.deactivate();
  } else {
    this.popScene();
  }
};

Scene_ItemBook.prototype.onCategoryOk = function() {
  this._categoryWindow.hide();
  this._categoryWindow.deselect();
  this._categoryWindow.deactivate();
  this._indexWindow.refresh();
  this._indexWindow.show();
  this._indexWindow.activate();
  this._itemPageWindow.setPage();
  this._itemPageWindow.activate();
};

Scene_ItemBook.prototype.createBackground = function() {
  Scene_MenuBase.prototype.createBackground.call(this);
  if (ItemBookBackGround) {
    const sprite = new Sprite();
    this.addChild(sprite);
    this._backGroundImg = sprite;
    sprite.x = BackUiWidth ? (Graphics.width - (Graphics.boxWidth + 8)) / 2 : 0;
    sprite.y = BackUiWidth ? (Graphics.height - (Graphics.boxHeight + 8)) / 2 : 0;
    $gameTemp.backGroundEbookRefresh = true;
  }
};

Scene_ItemBook.prototype.update = function() {
  Scene_MenuBase.prototype.update.call(this);
  if (this._backGroundImg && $gameTemp.backGroundEbookRefresh) {
    $gameTemp.backGroundEbookRefresh = false;
    const sprite = this._backGroundImg;
    const bitmapId = this._itembookWindow.getBackgroundId();
    if (backGroundId !== bitmapId) {
      backGroundId = bitmapId;
      bitmap = ImageManager.nuun_LoadPictures(BackGroundImg[bitmapId]);
      if (!bitmap.isReady()) {
        bitmap.addLoadListener(this.setBackground.bind(this, sprite, bitmap)); 
      } else {
        this.setBackground(sprite, bitmap);
      }
    }
  }
};

Scene_ItemBook.prototype.setBackground = function(sprite, bitmap) {
  sprite.bitmap = bitmap;
  if(BackUiWidth) {
    sprite.scale.x = (Graphics.boxWidth + 8 !== sprite.bitmap.width ? (Graphics.boxWidth + 8) / sprite.bitmap.width : 1);
    sprite.scale.y = (Graphics.boxHeight + 8!== sprite.bitmap.height ? (Graphics.boxHeight + 8) / sprite.bitmap.height : 1);
  } else {
    sprite.scale.x = (Graphics.width !== sprite.bitmap.width ? Graphics.width / sprite.bitmap.width : 1);
    sprite.scale.y = (Graphics.height !== sprite.bitmap.height ? Graphics.height / sprite.bitmap.height : 1);
  }
};

function Window_ItemBook_Category() {
  this.initialize(...arguments);
}

Window_ItemBook_Category.prototype = Object.create(Window_ItemCategory.prototype);
Window_ItemBook_Category.prototype.constructor = Window_ItemBook_Category;

Window_ItemBook_Category.prototype.initialize = function(rect) {
  Window_Command.prototype.initialize.call(this, rect);
  this._categorySelect = 0;
  this.setSelect();
  this._maxNum = 0;
};

Window_ItemBook_Category.prototype.itemTextAlign = function() {
  return "left";
};

Window_ItemBook_Category.prototype.maxCols = function() {
  return 1;
};

Window_ItemBook_Category.prototype.setItemWindow = function(itembookWindow) {
  this._itembookWindow = itembookWindow;
};

const _Window_ItemBook_Category_makeCommandList = Window_ItemBook_Category.prototype.makeCommandList;
Window_ItemBook_Category.prototype.makeCommandList = function() {
  const list = ItemBookCategory;
  if (list.length > 0) {
    list.forEach(names => {
      const categorykey = names.CategoryKey[0];
      if(categorykey === 'item') {
        this.addCommand(TextManager.item, categorykey);
      } else if(categorykey === 'weapon') {
        this.addCommand(TextManager.weapon, categorykey);
      } else if(categorykey === 'armor') {
        this.addCommand(TextManager.armor, categorykey);
      } else if(categorykey === 'keyItem') {
        this.addCommand(TextManager.keyItem, categorykey);
      } else if (categorykey === 'allItems') {
        this.addCommand(names.CategoryName, categorykey);
      } else if(names.CategoryName) { 
        this.addCommand(names.CategoryName, categorykey);
      }
    });
  } else {
    _Window_ItemBook_Category_makeCommandList.call(this);
  }
};

Window_ItemBook_Category.prototype.processOk = function() {
  this._itembookWindow.setCategory(this.currentSymbol());
  this._categorySelect = this.index();
  Window_Selectable.prototype.processOk.call(this);
};

Window_ItemBook_Category.prototype.setSelect = function() {
  this.select(this._categorySelect);
};

function Window_ItemBook_Percent() {
  this.initialize(...arguments);
}

Window_ItemBook_Percent.prototype = Object.create(Window_Selectable.prototype);
Window_ItemBook_Percent.prototype.constructor = Window_ItemBook_Percent;

Window_ItemBook_Percent.prototype.initialize = function(rect) {
  //this._userWindowSkin = PercentWindowsSkin;
  Window_Selectable.prototype.initialize.call(this, rect);
  this._itemPercent = {};
  this._duration = 0;
  this._oy = 0;
  this._percentContent = PercentContent || [];
  this._percentContentLength = this._percentContent.length;
};

Window_ItemBook_Percent.prototype.percentRefresh = function() {
  this.completenessPercent();
  this.refresh();
};

Window_ItemBook_Percent.prototype.completenessPercent = function() {
  const bookAllItems = $gameSystem.getIsItemBook(getItemData('all'));
  this._itemPercent._allItemListLength = bookAllItems.length;
  this._itemPercent._allItemNum = $gameSystem.getItemBookInfoFlagsNum(bookAllItems);
  const bookItems = $gameSystem.getIsItemBook(getItemData('item'));
  this._itemPercent._itemListLength = bookItems.length;
  this._itemPercent._itemNum = $gameSystem.getItemBookInfoFlagsNum(bookItems);
  const bookWeapons = $gameSystem.getIsItemBook(getItemData('weapon'));
  this._itemPercent._weaponListLength = bookWeapons.length;
  this._itemPercent._weaponNum = $gameSystem.getItemBookInfoFlagsNum(bookWeapons);
  const bookArmors = $gameSystem.getIsItemBook(getItemData('armor'));
  this._itemPercent._armorListLength = bookArmors.length;
  this._itemPercent._armorNum = $gameSystem.getItemBookInfoFlagsNum(bookArmors);

  this._itemPercent.allComplete = Math.floor(this._itemPercent._allItemNum / this._itemPercent._allItemListLength * 100);
  this._itemPercent.itemComplete = Math.floor(this._itemPercent._itemNum / this._itemPercent._itemListLength * 100);
  this._itemPercent.weaponComplete = Math.floor(this._itemPercent._weaponNum / this._itemPercent._weaponListLength * 100);
  this._itemPercent.armorComplete = Math.floor(this._itemPercent._armorNum / this._itemPercent._armorListLength * 100);
};

Window_ItemBook_Percent.prototype.refresh = function() {
  const lineHeight = this.lineHeight();
  const rect = this.itemLineRect(0);
  let y = rect.y + (this._oy * -1);
  this.contents.clear();
  for (const content of this._percentContent) {
    const text = this.getParam(content);
    this.drawText(text, rect.x, y, rect.width, 'center');
    y += lineHeight;
  }
  const text = this.getParam(this._percentContent[0]);
  this.drawText(text, rect.x, y, rect.width, 'center');
};

Window_ItemBook_Percent.prototype.getParam = function(content) {
  switch (content.ContentDate) {
    case 0:
      return content.ContentName +' : '+ this._itemPercent.allComplete +' %';
    case 1:
      return content.ContentName +' : '+ this._itemPercent.itemComplete +' %';
    case 2:
      return content.ContentName +' : '+ this._itemPercent.weaponComplete +' %';
    case 3:
      return content.ContentName +' : '+ this._itemPercent.armorComplete +' %';
    case 10:
      return content.ContentName +' : '+ this._itemPercent._allItemNum  +'/'+ this._itemPercent._allItemListLength;
    case 11:
      return content.ContentName +' : '+ this._itemPercent._itemNum  +'/'+ this._itemPercent._itemListLength;
    case 12:
      return content.ContentName +' : '+ this._itemPercent._weaponNum  +'/'+ this._itemPercent._weaponListLength;
    case 13:
      return content.ContentName +' : '+ this._itemPercent._armorNum  +'/'+ this._itemPercent._armorListLength;
  }
};

Window_ItemBook_Percent.prototype.update = function() {
  Window_Selectable.prototype.update.call(this);
  if (this._percentContentLength > 1) {
    this._duration++;
    this.updateInterval();
  }
};

Window_ItemBook_Percent.prototype.updateInterval = function() {
  const lineHeight = this.lineHeight();
  if(this._duration >= Interval && this._duration < Interval + lineHeight){
    this._oy++;
    this.refresh();
  }
  if(this._duration >= Interval + lineHeight){
    this._duration = 0;
    if(this._oy >= lineHeight * this._percentContentLength){
       this._oy = 0;
    }
  }
};


function Window_ItemBook_Index() {
  this.initialize(...arguments);
}

Window_ItemBook_Index.prototype = Object.create(Window_ItemList.prototype);
Window_ItemBook_Index.prototype.constructor = Window_ItemBook_Index;

Window_ItemBook_Index._lastTopRow = 0;
Window_ItemBook_Index._lastIndex = 0;

Window_ItemBook_Index.prototype.initialize = function(rect) {
  //this._userWindowSkin = param.IndexWindowsSkin;
  Window_ItemList.prototype.initialize.call(this, rect);
  this._itemType = 0;
  backGroundId = -1;
};

Window_ItemBook_Index.prototype.setSelect = function() {
  if (this._categoryWindow.needsSelection()) {
    Window_ItemBook_Index._lastIndex = this.maxItems() > 0 ? Math.min(Window_ItemBook_Index._lastIndex, this.maxItems() - 1) : 0;
  }
  if (Window_ItemBook_Index._lastTopRow + this.maxPageRows() - 1 < Window_ItemBook_Index._lastIndex) {
    Window_ItemBook_Index._lastTopRow += 1;
  }
  this.setTopRow(Window_ItemBook_Index._lastTopRow);
  this.select(Window_ItemBook_Index._lastIndex);
};

Window_ItemBook_Index.prototype.updateIndex = function() {
  Window_ItemBook_Index._lastTopRow = this.topRow();
  Window_ItemBook_Index._lastIndex = this.index();
};

Window_ItemBook_Index.prototype.maxCols = function() {
  return 1;
};

Window_ItemBook_Index.prototype.select = function(index) {
  Window_Selectable.prototype.select.call(this, index);
  this.updateItemData();
};

Window_ItemBook_Index.prototype.getItem = function() {
  return this._data[this.index()];
};

Window_ItemBook_Index.prototype.updatePercent = function() {
  if (this._percentWindow) {
    //const itemList = this._itemPercentList;
    this._percentWindow.percentRefresh();
  }
};

Window_ItemBook_Index.prototype.updateItemData = function() {
  if (this._itemWindow) {
    this._itemWindow.setItem(this.getItem());
  }
  if (this._pageWindow) {
    this._pageWindow.setItem(this.getItem());
  }
  if (this.active) {
    $gameTemp.backGroundEbookRefresh = true;
  }
};

Window_ItemBook_Index.prototype.makeItemList = function() {
  this._itemPercentList = [];
  this._data = this.allItemData().filter(item => this.itemBookIncludes(item));
};

Window_ItemBook_Index.prototype.isCurrentItemEnabled = function() {
  return true;
};

Window_ItemBook_Index.prototype.itemBookIncludes = function(item) {
  const result = $gameSystem.isItemBook(item);
  if (result) {
    this._itemPercentList.push(item);
  }
  return this.categoryIncludes(item) && result;
};

Window_ItemBook_Index.prototype.categoryIncludes = function(item) {
  if (this._category === 'allItems' && !this.secretItem(item) && item) {
    return true;
  } else if (this._category === 'allItem' && !this.secretItem(item) && item) {
    return DataManager.isItem(item);
  }
  const type = item ? item.meta[ItemBookCategoryTagName] : null;
  const category = this.includes(item);
  if(category && !type) {
    return category;
  }
  if (this._category === type) {
    return true;
  }
  return false;
};

Window_ItemBook_Index.prototype.includes = function(item) {
  switch (this._category) {
      case "item":
          return DataManager.isItem(item) && item.itypeId === 1;
      case "weapon":
          return DataManager.isWeapon(item);
      case "armor":
          return DataManager.isArmor(item);
      case "keyItem":
          return DataManager.isItem(item) && item.itypeId === 2;
      default:
          return false;
  }
};

Window_ItemBook_Index.prototype.secretItem = function(item) {
  if(DataManager.isItem(item) && item.itypeId > 2) {
    return true;
  }
  return false;
};

Window_ItemBook_Index.prototype.unknownEnemyVisible = function(item) {
  return !UnknownVisible || (UnknownVisible && $gameSystem.isInItemBook(item));
};

Window_ItemBook_Index.prototype.allItemData = function() {
  return getAllItemData();
};

Window_ItemBook_Index.prototype.drawItem = function(index) {
  const item = this.itemAt(index);
  if (item) {
    const rect = this.itemLineRect(index);
    if(NumberType > 0) {
      let numberText = NumberMode ? index + 1 : $gameSystem.getItemBookNumber(item);
      const numberWidth = this.numberWidth(numberText);
      if (NumberType === 2) {
        numberText = this.numberWidthSlice(numberText);
      }
      this.drawText(numberText, rect.x, rect.y, numberWidth);
      this.drawText(":", rect.x + numberWidth + 6, rect.y);
      if ($gameSystem.isInItemBook(item)) {
        this.drawItemName(item, rect.x + numberWidth + 24, rect.y, rect.width - numberWidth - 24);
      } else {
        this.drawText(this.unknownDataLength(item), rect.x + numberWidth + 24, rect.y, rect.width - numberWidth - 24);
      }
    } else {
      if ($gameSystem.isInItemBook(item)) {
        this.drawItemName(item, rect.x, rect.y, rect.width);
      } else {
        this.drawText(this.unknownDataLength(item), rect.x, rect.y, rect.width);
      }
    }
  }
};

Window_ItemBook_Index.prototype.refresh = function() {
  this.makeItemList();
  this.updatePercent();
  this.setSelect();
  Window_Selectable.prototype.refresh.call(this);
};

Window_ItemBook_Index.prototype.numberWidth = function() {
  return this.textWidth($gameSystem._itemBookLength >= 1000 || NumberType === 2 ? '000' : '00');
};

Window_ItemBook_Index.prototype.numberWidthSlice = function(indexText) {
  return ($gameSystem._itemBookLength >= 1000 ? ('0000' + indexText).slice(-4) : ('000' + indexText).slice(-3));
};

Window_ItemBook_Index.prototype.unknownDataLength = function(item) {
  if(UnknownData === '？' || UnknownData === '?') {
    const name_length = this.itemNameLength(item);
    return UnknownData.repeat(name_length);
  } else {
    return UnknownData;
  }
};

Window_ItemBook_Index.prototype.itemNameLength = function(item) {
	return item.name.length;
};

Window_ItemBook_Index.prototype.processCancel = function() {
  this.updateIndex();
  Window_ItemList.prototype.processCancel.call(this);
};

Window_ItemBook_Index.prototype.setCategoryWindow = function(categoryWindow) {
  this._categoryWindow = categoryWindow;
};

Window_ItemBook_Index.prototype.setPageWindow = function(pageWindow) {
  this._pageWindow = pageWindow;
};

Window_ItemBook_Index.prototype.setPercentWindow = function(percentWindow) {
  this._percentWindow = percentWindow;
  this.refresh();
};

Window_ItemBook_Index.prototype.setItemWindow = function(itemWindow) {
  this._itemWindow = itemWindow;
};

Window_ItemBook_Index.prototype.isConstructor = function() {
  return this._className === 'Window_ItemBook_Index';
};

function Window_ItemBook() {
  this.initialize(...arguments);
}

Window_ItemBook.prototype = Object.create(Window_Selectable.prototype);
Window_ItemBook.prototype.constructor = Window_ItemBook;

Window_ItemBook.prototype.initialize = function(rect) {
  //this._userWindowSkin = param.ContentWindowsSkin;
  Window_Selectable.prototype.initialize.call(this, rect);
  this.language_Jp = $gameSystem.isJapanese();
  this._additionalSprites = {};
  this._item = null;
  this._itemData = [];
  this._weaponData = [];
  this._armorData = [];
  this._pageMode = 0;
  this.displayList = null;
  this._itemType = null;
  this.refresh();
};

Window_ItemBook.prototype.setHelpWindow = function(helpWindow) {
  this._helpWindow = helpWindow;
};

Window_ItemBook.prototype.getBackgroundId = function() {
  const displayList = this.setDisplayList(this._item);
  return displayList && displayList.length > 0 ? 
  (Math.max(displayList[this._pageMode].PageBackGroundId, 1) - 1 || 0) : 0;
};

Window_ItemBook.prototype.setItem = function(item) {
  if(this._item !== item) {
    this._item = item;
    this.refresh();
  }
};

Window_ItemBook.prototype.maxCols = function() {
  return ContentCols;
};

Window_ItemBook.prototype.refresh = function() {
  if (!this._item || this._pageMode < 0) {
    this.contents.clear();
    this.updateHelp();
    return;
  }
  this.contents.clear();
  if (!$gameSystem.isInItemBook(this._item)) {
    this.setHelpWindowItem(null);
    return;
  }
  this.updateHelp();
  this.page(this._item);
};

Window_ItemBook.prototype.updateHelp = function() {
  this.setHelpWindowItem(this._item);
};

Window_ItemBook.prototype.getItemBitmap = function(listContent, item) {
  let bitmap = null;
  for (const data of listContent) {
    const commonItemBitmap = data.DateSelect === 100 && data.ImgData && data.ImgData[0] ? ImageManager.nuun_LoadPictures(data.ImgData[0]) : null;
    const itemBitmapData = data.DateSelect === 101 ? this.getItemImg(data, item) : null;
    const itemBitmap = itemBitmapData ? ImageManager.nuun_LoadPictures(itemBitmapData[0]) : null;
    if (commonItemBitmap && !commonItemBitmap.isReady()) {
      bitmap = commonItemBitmap;
    } else if (itemBitmap && !itemBitmap.isReady()) {
      bitmap = itemBitmap;
    }
  }
  return bitmap;
};

Window_ItemBook.prototype.getItemImg = function(data, item) {
    if (item.meta[data.textMethod]) {
        const arr = item.meta[data.textMethod].split(',');
        arr[0] = ImgFolder +"/"+ arr[0].trim();
        return arr;
    } else {
        let itemData = null;
        try {
            if (DataManager.isItem(item)) {
                itemData = ItemBookImgList.find(a => a.Item === item.id);
            } else if (DataManager.isWeapon(item)) {
                itemData = WeaponItemBookImgList.find(a => a.Item === item.id);
            } else if (DataManager.isArmor(item)) {
                itemData = ArmorItemBookImgList.find(a => a.Item === item.id);
            }
            if (itemData) {
                return [itemData.ItemImg, itemData.ItemX, itemData.ItemY];
            }
        } catch (e) {
            return null;
        }
        return null;
    }
};

Window_ItemBook.prototype.page = function(item) {
  const displayList = this.setDisplayList(item);
  if (!displayList || displayList.length <= 0) {
    return;
  }
  const listContent = displayList[this._pageMode].displayData;
  const bitmap = this.getItemBitmap(listContent, item);
  if (bitmap) {
    bitmap.addLoadListener(this.drawPage.bind(this, listContent, item));
  } else {
    this.drawPage(listContent, item);
  }
};

Window_ItemBook.prototype.drawPage = function(listContent, item) {
  const lineHeight = this.lineHeight();//console.log(item)
  for (const data of listContent) {
    const x_Position = data.X_Position;
    const position = Math.min(x_Position, this.maxCols());
    const rect = this.itemRect(position - 1);
    const x = rect.x + (data.X_Coordinate || 0);
    const y = (data.Y_Position - 1) * lineHeight + rect.y + (data.Y_Coordinate || 0);
    const width = data.ItemWidth && data.ItemWidth > 0 ? data.ItemWidth : this.widthMode(data, rect);
    this.dataDisplay(data, item, x, y, width);
  }
};

Window_ItemBook.prototype.setDisplayList = function(item) {
  if (DataManager.isItem(item)) {
    this._itemType = 'item';
    return ItemPageSetting;
  } else if (DataManager.isWeapon(item)) {
    this._itemType = 'weapon';
    return WeaponPageSetting;
  } else if (DataManager.isArmor(item)) {
    this._itemType = 'armor';
    return ArmorPageSetting;
  }
  this._itemType = null;
  return null;
};

Window_ItemBook.prototype.widthMode = function(list, rect) {
  if (list.WideMode === 2) {
    rect.width = rect.width * 2 + this.colSpacing();
  } else if (list.WideMode === 3 && ContentCols === 3) {
    rect.width = rect.width * 3 + (this.colSpacing() * 2);
  }
  return rect.width;
};

Window_ItemBook.prototype.dataDisplay = function(list, item, x, y, width) {
  switch (list.DateSelect) {
    case 0:
      break;
    case 1:
      this.itemName(list, item, x, y, width);
      break;
    case 2:
      this.bookEnemyNo(list, item, x, y, width);
      break;
    case 3:
      this.itemNumberOfPossession(list, item, x, y, width);
      break;
    case 4:
      this.itemMaxNumberOfPossession(list, item, x, y, width);
      break;
    case 5:
      this.itemPrice(list, item, x, y, width);
      break;
    case 6:
    case 7:
    case 8:
      this.originalParams(list, item, x, y, width);
      break;
    case 9:
      this.drawDesc(list, item, x, y, width);
      break;
    case 10:
      this.useItemOccasion(list, item, x, y, width);
      break;
    case 11:
      this.useItemConsumable(list, item, x, y, width);
      break;
    case 12:
      this.speedCorrection(list, item, x, y, width);
      break;
    case 13:
      this.successRate(list, item, x, y, width);
      break;
    case 14:
      this.tpGain(list, item, x, y, width);
      break;
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
      this.param(list, item, x, y, width);
      break;
    case 30:
      this.weaponType(list, item, x, y, width);
      break;
    case 31:
      this.armorType(list, item, x, y, width);
      break;
    case 32:
      this.equipType(list, item, x, y, width);
      break;
    case 40:
        //this.xparam(list, item, x, y, width);
        break;
    case 41:
        //this.sparam(list, item, x, y, width);
        break;
    case 51:
      this.name(list, item, x, y, width);
      break;
    case 52:
      this.horzLine(list, item, x, y, width);
      break;
    case 100:
      this.commonItemBitmap(list, item, x, y, width);
      break;
    case 101:
      this.itemBitmap(list, item, x, y, width);
      break;
    case 103:
    case 111:
    case 112:
    case 121:
    case 122:
    case 123:
    case 123:
    case 131:
    case 132:
    case 133:
    default:
      break;
  }
};

Window_ItemBook.prototype.itemName = function(list, item, x, y, width) {
  this.changeTextColor(this.getColorCode(list.NameColor));
  const text = item.name;
  const iconId = item.iconIndex;
  if (iconId > 0) {
    const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
    const textMargin = iconId > 0 ? ImageManager.iconWidth + 4 : 0;
    const itemWidth = Math.max(0, width - textMargin);
    const textWidth = this.textWidth(text);
    const width2 = Math.min(itemWidth, textWidth);
    if(list.namePosition === 'center') {
      this.drawIcon(iconId, x + (width / 2 - width2 / 2) - textMargin / 2, iconY);
    } else if (list.namePosition === 'left') {
      this.drawIcon(iconId, x, iconY);
    } else {
      this.drawIcon(iconId, x + itemWidth - width2, iconY);
    }
    this.drawText(text, x + textMargin, y, itemWidth, list.namePosition);
  } else {
    this.drawText(text, x, y, width, list.namePosition);
  }
};

Window_ItemBook.prototype.horzLine = function(list, item, x, y, width) {
  const lineY = y + this.lineHeight() / 2 - 1;
  this.contents.paintOpacity = 48;
  this.contents.fillRect(x, lineY, width, 2, this.getColorCode(list.NameColor));
  this.contents.paintOpacity = 255;
};

Window_ItemBook.prototype.name = function(list, item, x, y, width) {
  const nameText = list.paramName;
  if (nameText) {
    this.changeTextColor(this.getColorCode(list.NameColor));
    this.drawText(nameText, x, y, width, list.namePosition);
  }
};

Window_ItemBook.prototype.bookEnemyNo = function(list, item, x, y, width) {
  const nameText = list.paramName;
  let textWidth  = 0;
  if (nameText) {
    this.changeTextColor(this.getColorCode(list.NameColor));
    this.drawText(nameText, x, y, width, list.namePosition);
    textWidth = this.textWidth(nameText) + this.itemPadding();
    this.resetTextColor();
  }
  let text = $gameSystem.getItemBookNumber(item);
  if (NumberType === 2) {
    text = this.numberWidthSlice(text);
  }
  this.drawText(text, x + textWidth, y, width - textWidth, "left");
};

Window_ItemBook.prototype.itemNumberOfPossession = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : "所持数";
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : $gameParty.numItems(item);
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.itemMaxNumberOfPossession = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "最大所持数" : "Max possession");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : $gameParty.maxItems(item);
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.itemPrice = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "価格" : "Price");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : item.price;
    this.drawCurrencyValue(text, this.currencyUnit(), x + textWidth + 8, y, width - (textWidth + 8));
  } else {
    text = UnknownItemData;
    this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
  }
};

Window_ItemBook.prototype.originalParams = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName;
  let textWidth = width;
  if (nameText) {
    textWidth = this.systemWidth(list.SystemItemWidth, width);
    this.drawText(nameText, x, y, textWidth);
  }
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = eval(list.DetaEval);
    text += list.paramUnit ? String(list.paramUnit) : '';
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.drawDesc = function(list, item, x, y, width) {
  const nameText = list.paramName;
  if (nameText) {
    this.changeTextColor(this.getColorCode(list.NameColor));
    this.drawText(nameText, x, y);
    y += this.lineHeight();
  }
  this.resetTextColor();
  if(this.paramMask(list.MaskMode)){
    let text = list.DetaEval;
    if (!text) {
      const method = list.textMethod;
      if (method) {
        text = item.meta[method];
      }
    } else {
      text = eval(text);
    }
    if(text){
      this.drawTextEx(text, x, y, width);
    }
  }
};

Window_ItemBook.prototype.useItemOccasion = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "使用可能時" : "Occasion");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : this.useItemOccasionName(item);
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.useItemConsumable = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "消耗" : "Consume");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : this.itemConsumable(item);
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.speedCorrection = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "速度補正" : "Speed");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : item.speed;
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.successRate = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "成功率" : "Success");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : item.successRate;
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.tpGain = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "得TP" : "TP Gain");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : item.tpGain;
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.param = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : TextManager.param(list.DateSelect - 20);
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : item.params[list.DateSelect - 20];
    text += list.paramUnit ? String(list.paramUnit) : '';
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.xparam = function(list, item, x, y, width) {
    this.drawContentsBackground(list.Back, x, y, width);
    x = this.contensX(x);
    width = this.contensWidth(width);
    this.changeTextColor(this.getColorCode(list.NameColor));
    const nameText = list.paramName ? list.paramName : TextManager.xparam(list.ParamId);
    const textWidth = this.systemWidth(list.SystemItemWidth, width);
    this.drawText(nameText, x, y, textWidth);
    this.resetTextColor();
    let text;
    if(this.paramMask(list.MaskMode)){
      text = list.DetaEval ? eval(list.DetaEval) : this.getXparam(list, item);
      text += list.paramUnit ? String(list.paramUnit) : '';
    } else {
      text = UnknownItemData;
    }
    this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.sparam = function(list, item, x, y, width) {
    this.drawContentsBackground(list.Back, x, y, width);
    x = this.contensX(x);
    width = this.contensWidth(width);
    this.changeTextColor(this.getColorCode(list.NameColor));
    const nameText = list.paramName ? list.paramName : TextManager.xparam(list.ParamId);
    const textWidth = this.systemWidth(list.SystemItemWidth, width);
    this.drawText(nameText, x, y, textWidth);
    this.resetTextColor();
    let text;
    if(this.paramMask(list.MaskMode)){
      text = list.DetaEval ? eval(list.DetaEval) : this.getSparam(list, item);
      text += list.paramUnit ? String(list.paramUnit) : '';
    } else {
      text = UnknownItemData;
    }
    this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.getXparam = function(list, item) {
    return item.traits.reduce((r, data) => data.code === 22 && data.dataId === list.ParamId ? r + data.value : r, 0);
};

Window_ItemBook.prototype.getSparam = function(list, item) {
    return item.traits.reduce((r, data) => data.code === 23 && data.dataId === list.ParamId ? r + data.value : r, 0);
};

Window_ItemBook.prototype.weaponType = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "武器タイプ" : "Weapon type");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : $dataSystem.weaponTypes[item.wtypeId];
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.armorType = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "防具タイプ" : "Armmor type");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : $dataSystem.armorTypes[item.atypeId];
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.equipType = function(list, item, x, y, width) {
  this.drawContentsBackground(list.Back, x, y, width);
  x = this.contensX(x);
  width = this.contensWidth(width);
  this.changeTextColor(this.getColorCode(list.NameColor));
  const nameText = list.paramName ? list.paramName : (this.language_Jp ? "装備タイプ" : "Equipment type");
  const textWidth = this.systemWidth(list.SystemItemWidth, width);
  this.drawText(nameText, x, y, textWidth);
  this.resetTextColor();
  let text;
  if(this.paramMask(list.MaskMode)){
    text = list.DetaEval ? eval(list.DetaEval) : $dataSystem.equipTypes[item.etypeId];
  } else {
    text = UnknownItemData;
  }
  this.drawText(text, x + textWidth + 8, y, width - (textWidth + 8), 'right');
};

Window_ItemBook.prototype.commonItemBitmap = function(list, item, x, y, width) {
  const bitmap = ImageManager.nuun_LoadPictures(list.ImgData[0]);
  if (bitmap && !bitmap.isReady()) {
    bitmap.addLoadListener(this.drawImg.bind(this, bitmap, list, x, y, width));
  } else if (bitmap) {
    this.drawImg(bitmap, list, x, y, width);
  }
};

Window_ItemBook.prototype.itemBitmap = function(list, item, x, y, width) {
  const dataImg = this.getItemImg(list, item);
  if (dataImg) {
    //const bitmap = ImageManager.loadBitmap("img/"+ ImgFolder +"/", dataImg[0]);
    const bitmap = ImageManager.nuun_LoadPictures(dataImg[0]);
    x += Number(dataImg[1]) || 0;
    y += Number(dataImg[2]) || 0;
    if (!bitmap.isReady()) {
      bitmap.addLoadListener(this.drawImg.bind(this, bitmap, list, x, y, width));
    } else if (bitmap) {
      this.drawImg(bitmap, list, x, y, width);
    }
  }
};

Window_ItemBook.prototype.drawImg = function(bitmap, list, x, y, width) {
  const height = list.ImgMaxHeight * this.lineHeight();
  const scalex = Math.min(1.0, width / bitmap.width);
  const scaley = Math.min(1.0, height / bitmap.height);
  const scale = scalex > scaley ? scaley : scalex;
  const dw = Math.floor(bitmap.width * scale);
  const dh = Math.floor(bitmap.height * scale);
  x += Math.floor(width / 2 - dw / 2);
  this.contents.blt(bitmap, 0, 0, bitmap.width, bitmap.height, x, y, dw, dh);
};

Window_ItemBook.prototype.paramMask = function() {
  return $gameSystem.getItemBookInfoFlags(this._item);
  //return !this.noUnknownStatus() ? $gameSystem.getItemBookInfoFlags(this._item) : true;
};

Window_ItemBook.prototype.noUnknownStatus = function() {
  return this._item.meta.ShowDataBook;
};

Window_ItemBook.prototype.maxWidth = function() {
  return this.itemWidth() / 2 - this.itemPadding() * 2;
};

Window_ItemBook.prototype.systemWidth = function(swidth, width) {
  return swidth > 0 ? swidth : Math.floor(width / 3);
};

Window_ItemBook.prototype.contensX = function(x) {
  return x + (this.itemPadding() / 2);
};

Window_ItemBook.prototype.contensWidth = function(width) {
  return width - this.itemPadding();
};

Window_ItemBook.prototype.numberWidthSlice = function(indexText) {
  return ($gameSystem._itemBookLength >= 1000 ? ('0000' + indexText).slice(-4) : ('000' + indexText).slice(-3));
};

Window_ItemBook.prototype.currencyUnit = function() {
  return TextManager.currencyUnit;
};

Window_ItemBook.prototype.textParam = function(paramsId) {
  switch (paramsId) {
    case 0:
      return "会心率";
    case 1:
      return "会心回避率";
    case 2:
      return "魔法回避率";
    case 3:
      return "魔法反射率";
    case 4:
      return "反撃率";
    case 5:
      return "HP再生率";
    case 6:
      return "MP再生率";
    case 7:
      return "TP再生率";
    case 10:
      return "狙われ率";
    case 11:
      return "防御効果率";
    case 12:
      return "回復効果率";
    case 13:
      return "薬の知識";
    case 14:
      return "MP消費率";
    case 15:
      return "TPチャージ率";
    case 16:
      return "物理ダメージ率";
    case 17:
      return "魔法ダメージ率";
    case 18:
      return "床ダメージ率";
    case 19:
      return "獲得経験率";
    default:
      return null;
  }
};

Window_ItemBook.prototype.useItemOccasionName = function(item) {
  const occasion = item.occasion;
  if (occasion === 0) {
    return "常時";
  } else if (occasion === 1) {
    return "戦闘時";
  } else if (occasion === 2) {
    return "移動時";
  } else {
    return "使用不可";
  }
};

Window_ItemBook.prototype.itemConsumable = function(item) {
  return item.consumable ? "消耗する" : "消耗しない";
};

Window_ItemBook.prototype.drawContentsBackground = function(back, x, y, width) {
  if (back) {
    const rect = this.contentsRect(x, y, width);
    this.drawContentsBackgroundRect(rect);
  }
};

Window_ItemBook.prototype.drawContentsBackgroundRect = function(rect) {
    const c1 = ColorManager.itemBackColor1();
    const c2 = ColorManager.itemBackColor2();
    const x = rect.x;
    const y = rect.y;
    const w = rect.width;
    const h = rect.height;
    this.contents.gradientFillRect(x, y, w, h, c1, c2, true);
    this.contents.strokeRect(x, y, w, h, c1);
};

Window_ItemBook.prototype.contentsRect = function(x, y, width) {
  const height = this.lineHeight() - this.rowSpacing();
  return new Rectangle(x, y + 2, width, height);
};

Window_ItemBook.prototype.getColorCode = function(color) {
  if (typeof(color) === "string") {
    return color;
  }
  return ColorManager.textColor(color);
};

// 図鑑用 基本パラメータ能力値＋能力倍率取得
Window_ItemBook.prototype.getParamFull = function(item,index) {
  //console.log(item);
  var traitsParam = item.traits.filter(trait => trait.code === 21 && trait.dataId === index);
  var paramRaito = Math.round(traitsParam.reduce((r, trait) => r + trait.value, 0) * 100);
  if(paramRaito != 0){
      paramRaito = paramRaito - 100;
      if(paramRaito < 0){
          paramRaito = " - "  + (paramRaito * -1);
      }
      else{
          paramRaito = " + " + paramRaito;
      }
  }else{
      paramRaito = " + 0";
  }
  return item.params[index] + paramRaito + "%";
};

// 図鑑用 Xparam系取得
Window_ItemBook.prototype.getXparam = function(item,index) {
  var traitsParam = item.traits.filter(trait => trait.code === 22 && trait.dataId === index);
  var dispVal = Math.round(traitsParam.reduce((r, trait) => r + trait.value, 0) * 100);
  if(dispVal < 0){
      dispVal = " - "  + (dispVal * -1);
  }
  else{
      dispVal = " + " + dispVal;
  }
  return dispVal + "%"
};

/* 図鑑用 クリティカル倍率増幅値取得 */
Window_ItemBook.prototype.getCriMagniBst = function(item) {
    fullMagni = 0;
    if (item && item.meta && item.meta.CriMagniBst) fullMagni += Number(item.meta.CriMagniBst);
    if(fullMagni < 0){
        fullMagni = " - "  + (fullMagni * -1);
    }
    else{
        fullMagni = " + " + fullMagni;
    }
    return fullMagni + "%"
};

function Window_ItemBookPageCategory() {
  this.initialize(...arguments);
}

Window_ItemBookPageCategory.prototype = Object.create(Window_Selectable.prototype);
Window_ItemBookPageCategory.prototype.constructor = Window_ItemBookPageCategory;

Window_ItemBookPageCategory.prototype.initialize = function(rect) {
  //this._userWindowSkin = param.PageWindowsSkin;
  Window_Selectable.prototype.initialize.call(this, rect);
  this._pageSelect = 0;
  this._maxPage = 0;
  this._maxCols = 0;
  this._categoryId = -1;
  this._categorySelect = 0;
  this.select(this._categorySelect);
};

Window_ItemBookPageCategory.prototype.maxCols = function() {
  return PageCols;
};

Window_ItemBookPageCategory.prototype.listMode = function() {
  if (this._categoryId === 0) {
    return ItemPageSetting;
  } else if (this._categoryId === 1) {
    return WeaponPageSetting;
  } else if (this._categoryId === 2) {
    return ArmorPageSetting;
  }
  return null;
};

Window_ItemBookPageCategory.prototype.getItemCategory = function(item) {
  if (DataManager.isItem(item)) {
    return 0;
  } else if (DataManager.isWeapon(item)) {
    return 1;
  } else if (DataManager.isArmor(item)) {
    return 2;
  }
  return -1;
};

Window_ItemBookPageCategory.prototype.setItem = function(item) {
  this._item = item;
  const category = this.getItemCategory(item);
  if (this._categoryId !== category) {
    this._categoryId = category;
    this.setMaxPage();
    this.refresh();
  }
};

Window_ItemBookPageCategory.prototype.getItemList = function() {
  return this.listMode();
};

Window_ItemBookPageCategory.prototype.setMaxPage = function() {
  const list = this.getItemList();
  this._maxPage = list ? list.length : 0;
  this._pageSelect = Math.min(this._maxPage, this._pageSelect);
};

Window_ItemBookPageCategory.prototype.setPage = function() {
  this._pageSelect = 0;
  this.select(this._pageSelect);
};

Window_ItemBookPageCategory.prototype.select = function(index) {
  Window_Selectable.prototype.select.call(this, index);
  this.updateItemStatus();
};

Window_ItemBookPageCategory.prototype.updateItemStatus = function() {
  if (this.index() >= 0) {
    this._pageSelect = this.index();
  }
  if (this._itemWindow) {
    this._itemWindow._pageMode = this._pageSelect;
    if (this.active) {
      $gameTemp.backGroundEbookRefresh = true;
    }
    this._itemWindow.refresh();
  }
};

Window_ItemBookPageCategory.prototype.setItemWindow = function(itemWindow) {
  this._itemWindow = itemWindow;
};

Window_ItemBookPageCategory.prototype.setIndexWindow = function(indexWindow) {
  this._indexWindow = indexWindow;
};

Window_ItemBookPageCategory.prototype.maxItems = function() {
  return this._maxPage;
};

Window_ItemBookPageCategory.prototype.drawItem = function(index) {
  const rect = this.itemLineRect(index);
  const list = this.listMode();
  if (list) {
    const text = list[index].PageName ? list[index].PageName : "ページ"+ Number(index + 1);
    this.drawText(text, rect.x, rect.y, rect.width);
  }
};
})();